import{proxyCustomElement,HTMLElement,createEvent,h}from"@stencil/core/internal/client";import{s as setDefaultAnimation,g as getAnimation,a as animateTo,b as stopAnimations}from"./animation-registry.js";import{d as defineCustomElement$1}from"./sc-icon2.js";const scDrawerCss=":host {\n  display: contents;\n}\n.drawer {\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  pointer-events: none;\n  overflow: hidden;\n  font-family: var(--sc-font-sans);\n  font-weight: var(--sc-font-weight-normal);\n}\n.drawer--contained {\n  position: absolute;\n  z-index: initial;\n}\n.drawer--fixed {\n  position: fixed;\n  z-index: var(--sc-z-index-drawer);\n}\n.drawer__panel {\n  position: absolute;\n  display: flex;\n  flex-direction: column;\n  z-index: 2;\n  max-width: 100%;\n  max-height: 100%;\n  background-color: var(--sc-panel-background-color);\n  box-shadow: var(--sc-shadow-x-large);\n  transition: var(--sc-transition-medium) transform;\n  overflow: auto;\n  pointer-events: all;\n}\n.drawer__panel:focus {\n  outline: none;\n}\n.drawer--top .drawer__panel {\n  top: 0;\n  right: auto;\n  bottom: auto;\n  left: 0;\n  width: 100%;\n  height: var(--sc-drawer-size, 400px);\n}\n.drawer--end .drawer__panel {\n  top: 0;\n  right: 0;\n  bottom: auto;\n  left: auto;\n  width: 100%;\n  max-width: var(--sc-drawer-size, 400px);\n  height: 100%;\n}\n.drawer--bottom .drawer__panel {\n  top: auto;\n  right: auto;\n  bottom: 0;\n  left: 0;\n  width: 100%;\n  height: var(--sc-drawer-size, 400px);\n}\n.drawer--start .drawer__panel {\n  top: 0;\n  right: auto;\n  bottom: auto;\n  left: 0;\n  width: var(--sc-drawer-size, 400px);\n  height: 100%;\n}\n.header__sticky {\n  position: sticky;\n  top: 0;\n  z-index: 10;\n  background: #fff;\n}\n.drawer__header {\n  display: flex;\n  align-items: center;\n  padding: var(--sc-drawer-header-spacing);\n  border-bottom: var(--sc-drawer-border);\n}\n\n.drawer__title {\n  flex: 1 1 auto;\n  font: inherit;\n  font-size: var(--sc-font-size-large);\n  line-height: var(--sc-line-height-dense);\n  margin: 0;\n}\n.drawer__close {\n  flex: 0 0 auto;\n  display: flex;\n  align-items: center;\n  font-size: var(--sc-font-size-x-large);\n  color: var(--sc-color-gray-500);\n  cursor: pointer;\n}\n.drawer__body {\n  flex: 1 1 auto;\n}\n\n.drawer--has-footer .drawer__footer {\n  border-top: var(--sc-drawer-border);\n  padding: var(--sc-drawer-footer-spacing);\n\n  &.is-sticky {\n    position: sticky;\n    bottom: 0;\n    background: #fff;\n  }\n}\n\n.drawer__overlay {\n  display: block;\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  background-color: var(--sc-overlay-background-color);\n  pointer-events: all;\n}\n.drawer--contained .drawer__overlay {\n  position: absolute;\n}\n",ScDrawerStyle0=scDrawerCss,ScDrawer=proxyCustomElement(class extends HTMLElement{constructor(){super(),this.__registerHost(),this.__attachShadow(),this.scInitialFocus=createEvent(this,"scInitialFocus",7),this.scRequestClose=createEvent(this,"scRequestClose",7),this.scShow=createEvent(this,"scShow",7),this.scHide=createEvent(this,"scHide",7),this.scAfterShow=createEvent(this,"scAfterShow",7),this.scAfterHide=createEvent(this,"scAfterHide",7),this.open=!1,this.label="",this.placement="end",this.contained=!1,this.noHeader=!1,this.stickyHeader=!1,this.stickyFooter=!1}componentDidLoad(){this.drawer.hidden=!this.open,this.open&&!this.contained&&this.lockBodyScrolling(),this.handleOpenChange()}disconnectedCallback(){this.unLockBodyScrolling()}lockBodyScrolling(){document.body.classList.add("sc-scroll-lock")}unLockBodyScrolling(){document.body.classList.remove("sc-scroll-lock")}async show(){this.open||(this.open=!0)}async hide(){this.open&&(this.open=!1)}async requestClose(e="method"){if(this.scRequestClose.emit(e).defaultPrevented){const e=getAnimation(this.el,"drawer.denyClose");animateTo(this.panel,e.keyframes,e.options)}else this.hide()}handleKeyDown(e){"Escape"===e.key&&(e.stopPropagation(),this.requestClose("keyboard"))}async handleOpenChange(){if(this.open){this.scShow.emit(),this.originalTrigger=document.activeElement,this.contained||this.lockBodyScrolling();const e=this.el.querySelector("[autofocus]");e&&e.removeAttribute("autofocus"),await Promise.all([stopAnimations(this.drawer),stopAnimations(this.overlay)]),this.drawer.hidden=!1,requestAnimationFrame((()=>{this.scInitialFocus.emit().defaultPrevented||(e?e.focus({preventScroll:!0}):this.panel.focus({preventScroll:!0})),e&&e.setAttribute("autofocus","")}));const t=getAnimation(this.el,`drawer.show${this.placement.charAt(0).toUpperCase()+this.placement.slice(1)}`),a=getAnimation(this.el,"drawer.overlay.show");await Promise.all([animateTo(this.panel,t.keyframes,t.options),animateTo(this.overlay,a.keyframes,a.options)]),this.scAfterShow.emit()}else{this.scHide.emit(),this.unLockBodyScrolling(),await Promise.all([stopAnimations(this.drawer),stopAnimations(this.overlay)]);const e=getAnimation(this.el,`drawer.hide${this.placement.charAt(0).toUpperCase()+this.placement.slice(1)}`),t=getAnimation(this.el,"drawer.overlay.hide");await Promise.all([animateTo(this.panel,e.keyframes,e.options),animateTo(this.overlay,t.keyframes,t.options)]),this.drawer.hidden=!0;const a=this.originalTrigger;"function"==typeof(null==a?void 0:a.focus)&&setTimeout((()=>a.focus())),this.scAfterHide.emit()}}render(){return h("div",{key:"7dadb4070dcaa9961a8157e99539d8f7f7829d2c",part:"base",class:{drawer:!0,"drawer--open":this.open,"drawer--top":"top"===this.placement,"drawer--end":"end"===this.placement,"drawer--bottom":"bottom"===this.placement,"drawer--start":"start"===this.placement,"drawer--contained":this.contained,"drawer--fixed":!this.contained,"drawer--has-footer":null!==this.el.querySelector('[slot="footer"]')},ref:e=>this.drawer=e,onKeyDown:e=>this.handleKeyDown(e)},h("div",{key:"bd474c990309f52201fd8a1824ebedc1349b77f5",part:"overlay",class:"drawer__overlay",onClick:()=>this.requestClose("overlay"),tabindex:"-1",ref:e=>this.overlay=e}),h("div",{key:"d2ca5b4cba978a93e8313aaf69c8c865d5a2b019",part:"panel",class:"drawer__panel",role:"dialog","aria-modal":"true","aria-hidden":this.open?"false":"true","aria-label":this.noHeader?this.label:void 0,"aria-labelledby":this.noHeader?void 0:"title",tabindex:"0",ref:e=>this.panel=e},!this.noHeader&&h("header",{key:"2b0e6f172ecd812b77f14a7c9757098cde7e7cac",part:"header",class:this.stickyHeader?"header__sticky":""},h("slot",{key:"3d0839a3ed04c2dcae28520c7359a5b8d8b269e6",name:"header"},h("div",{key:"d0a8bd55f112e3d52b59b462bd5eac021edfe118",class:"drawer__header"},h("h2",{key:"f706738c2b987059bd9e32e4efc8fca528c9a09d",part:"title",class:"drawer__title",id:"title"},h("slot",{key:"9bc78f0a63eb76e51f93c160d7d2f44269c50d26",name:"label"},this.label.length>0?this.label:" "," ")),h("sc-icon",{key:"4496761c6f252037b8099f53457f322ef69d4037",part:"close-button",exportparts:"base:close-button__base",class:"drawer__close",name:"x",label:
/** translators: Close this modal window. */
wp.i18n.__("Close","surecart"),onClick:()=>this.requestClose("close-button")})))),h("footer",{key:"9d40f363879851afa181550d41fe9b5337e0038d",part:"header-suffix",class:"drawer__header-suffix"},h("slot",{key:"911962643997621d9f276bf908c199f76081ba05",name:"header-suffix"})),h("div",{key:"ab386152dbdf5341fdefc2335193d7d22c32d3e8",part:"body",class:"drawer__body"},h("slot",{key:"001144ddd4ac4da72ccc03354171ae03d19ec54c"})),h("footer",{key:"c6f8a32c1a65513510a139e1cf26881106cad672",part:"footer",class:this.stickyFooter?"drawer__footer is-sticky":"drawer__footer"},h("slot",{key:"a8131ebe2cd87fe8c57b0d5f346b5c3035b5ef38",name:"footer"}))))}get el(){return this}static get watchers(){return{open:["handleOpenChange"]}}static get style(){return ScDrawerStyle0}},[1,"sc-drawer",{open:[516],label:[513],placement:[513],contained:[516],noHeader:[516,"no-header"],stickyHeader:[4,"sticky-header"],stickyFooter:[4,"sticky-footer"],requestClose:[64]},void 0,{open:["handleOpenChange"]}]);function defineCustomElement(){"undefined"!=typeof customElements&&["sc-drawer","sc-icon"].forEach((e=>{switch(e){case"sc-drawer":customElements.get(e)||customElements.define(e,ScDrawer);break;case"sc-icon":customElements.get(e)||defineCustomElement$1()}}))}setDefaultAnimation("drawer.showTop",{keyframes:[{opacity:0,transform:"translateY(-100%)"},{opacity:1,transform:"translateY(0)"}],options:{duration:250,easing:"ease"}}),setDefaultAnimation("drawer.hideTop",{keyframes:[{opacity:1,transform:"translateY(0)"},{opacity:0,transform:"translateY(-100%)"}],options:{duration:250,easing:"ease"}}),setDefaultAnimation("drawer.showEnd",{keyframes:[{opacity:0,transform:"translateX(100%)"},{opacity:1,transform:"translateX(0)"}],options:{duration:250,easing:"ease"}}),setDefaultAnimation("drawer.hideEnd",{keyframes:[{opacity:1,transform:"translateX(0)"},{opacity:0,transform:"translateX(100%)"}],options:{duration:250,easing:"ease"}}),setDefaultAnimation("drawer.showBottom",{keyframes:[{opacity:0,transform:"translateY(100%)"},{opacity:1,transform:"translateY(0)"}],options:{duration:250,easing:"ease"}}),setDefaultAnimation("drawer.hideBottom",{keyframes:[{opacity:1,transform:"translateY(0)"},{opacity:0,transform:"translateY(100%)"}],options:{duration:250,easing:"ease"}}),setDefaultAnimation("drawer.showStart",{keyframes:[{opacity:0,transform:"translateX(-100%)"},{opacity:1,transform:"translateX(0)"}],options:{duration:250,easing:"ease"}}),setDefaultAnimation("drawer.hideStart",{keyframes:[{opacity:1,transform:"translateX(0)"},{opacity:0,transform:"translateX(-100%)"}],options:{duration:250,easing:"ease"}}),setDefaultAnimation("drawer.denyClose",{keyframes:[{transform:"scale(1)"},{transform:"scale(1.01)"},{transform:"scale(1)"}],options:{duration:250}}),setDefaultAnimation("drawer.overlay.show",{keyframes:[{opacity:0},{opacity:1}],options:{duration:250,easing:"ease"}}),setDefaultAnimation("drawer.overlay.hide",{keyframes:[{opacity:1},{opacity:0}],options:{duration:250,easing:"ease"}});export{ScDrawer as S,defineCustomElement as d};